<?php

namespace App\Http\Requests\Article;

use Illuminate\Foundation\Http\FormRequest;

class UpdateArticleRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'title' => 'sometimes|required|string|max:255',
            'content' => 'sometimes|required|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'author' => 'sometimes|required|string|max:255',
            'category_id' => 'nullable|exists:article_categories,id',
            'excerpt' => 'nullable|string',
            'published_at' => 'nullable|date',
            'is_featured' => 'nullable|boolean',
            'is_active' => 'nullable|boolean',
            'slug' => 'nullable|string|unique:articles,slug,' . $this->article->id
        ];
    }

    public function messages(): array
    {
        return [
            'title.required' => 'The article title is required',
            'title.max' => 'The article title cannot exceed 255 characters',
            'content.required' => 'The article content is required',
            'image.image' => 'The file must be an image',
            'author.required' => 'The author name is required',
            'category_id.exists' => 'The selected category does not exist',
            'slug.unique' => 'This slug is already in use'
        ];
    }
} 