<?php

namespace App\Http\Requests\Contact;

use Illuminate\Foundation\Http\FormRequest;

class UpdateContactRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'is_read' => 'required|boolean'
        ];
    }

    public function messages(): array
    {
        return [
            'is_read.required' => 'The read status is required',
            'is_read.boolean' => 'The read status must be true or false'
        ];
    }
} 