<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CompanyResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'subtitle' => $this->subtitle,
            'number_of_blocks' => $this->number_of_blocks,
            'content_blocks' => $this->whenLoaded('contentBlocks', function() {
                return $this->contentBlocks->map(function($block) {
                    return [
                        'id' => $block->id,
                        'content' => $block->content,
                        'display_order' => $block->display_order,
                        'image_position' => $block->image_position,
                        'images' => $block->images->map(function($image) {
                            return [
                                'id' => $image->id,
                                'image_path' => asset($image->image_path),
                                'display_order' => $image->display_order
                            ];
                        })
                    ];
                });
            })
        ];
    }
}