<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyInformation extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'subtitle',
        'number_of_blocks',
    ];

    public function contentBlocks()
    {
        return $this->hasMany(CompanyContentBlock::class, 'company_information_id')
                    ->orderBy('display_order', 'asc');
    }
}
