<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Resources\CompanyResource;
use App\Services\CompanyService;
use App\Traits\ApiResponse;

class CompanyController extends Controller
{
    use ApiResponse;

    protected $companyService;

    public function __construct(CompanyService $companyService)
    {
        $this->companyService = $companyService;
    }

    public function show()
    {
        $company = $this->companyService->getCompanyInfo();
        
        if (!$company) {
            return $this->errorResponse('Company information not found', 404);
        }
        
        return $this->successResponse(
            new CompanyResource($company),
            'Company information retrieved successfully',
            200
        );
    }

    public function update(Request $request)
    {
        $company = $this->companyService->updateCompanyInfo($request->all());
        
        return $this->successResponse(
            new CompanyResource($company),
            'Company information updated successfully',
            200
        );
    }
}