<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\OurClient;
use App\Http\Resources\OurClientResource;
use App\Services\OurClientService;
use App\Http\Requests\OurClient\StoreOurClientRequest;
use App\Http\Requests\OurClient\UpdateOurClientRequest;
use App\Traits\ApiResponse;
use Illuminate\Support\Facades\Log;
class OurClientController extends Controller
{
    use ApiResponse;

    protected $ourClientService;

    public function __construct(OurClientService $ourClientService)
    {
        $this->ourClientService = $ourClientService;
    }

    public function index()
    {
        $clients = $this->ourClientService->getAllActiveClients();
        return $this->successResponse(
            OurClientResource::collection($clients), 
            'Clients fetched successfully',
            200
        );
    }

    public function show(OurClient $client)
    {
        return $this->successResponse(
            new OurClientResource($client), 
            'Client fetched successfully',
            200
        );
    }

    public function store(StoreOurClientRequest $request)
    {
        $client = $this->ourClientService->createClient($request->validated());
        return $this->successResponse(
            new OurClientResource($client), 
            'Client created successfully',
            201
        );
    }
    
    public function update(UpdateOurClientRequest $request, OurClient $ourClient)
    {
        // Log::info($request->all());
        $client = $this->ourClientService->updateClient($ourClient, $request->validated());
        return $this->successResponse(
            new OurClientResource($client), 
            'Client updated successfully',
            200
        );
    }
    
    public function destroy(OurClient $client)
    {
        $this->ourClientService->deleteClient($client);
        return $this->successResponse(
            null, 
            'Client deleted successfully',
            204
        );
    }
}
