<?php

namespace App\Http\Requests\Company;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'title' => 'required|string|max:255',   
            'subtitle' => 'required|string|max:255',
            'blocks' => 'required|array|min:1',
            'blocks.*.content' => 'required|string',
            'blocks.*.display_order' => 'required|string',
            'blocks.*.image_position' => 'required|string|in:left,right,top,bottom',
            'blocks.*.images' => 'nullable|array',
            'blocks.*.images.*' => 'required|file|mimes:jpeg,png,jpg,gif|max:2048',
        ];
    }

}
