<?php

namespace App\Http\Requests\OurClient;

use Illuminate\Foundation\Http\FormRequest;

class StoreOurClientRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name' => 'required|string|max:255',
            'logo_path' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'website_url' => 'nullable|url',
            'display_order' => 'nullable|integer',
            'is_active' => 'required',
        ];
    }
}
