<?php

namespace App\Http\Requests\OurClient;

use Illuminate\Foundation\Http\FormRequest;

class UpdateOurClientRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name' => 'sometimes|required|string|max:255',
            'logo_path' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'website_url' => 'sometimes|nullable|url',
            'display_order' => 'sometimes|nullable|integer',
        ];
    }

    public function messages()
    {
        return [
            'name.required' => 'The name field is required.',
            'logo_path.image' => 'The logo must be an image.',
            'logo_path.mimes' => 'The logo must be a file of type: jpeg, png, jpg, gif, svg.',
            'logo_path.max' => 'The logo may not be greater than 2MB.',
            'website_url.url' => 'The website URL format is invalid.',
            'display_order.integer' => 'The display order must be an integer.',
        ];
    }
}
