<?php

namespace App\Http\Requests\Portfolio;

use Illuminate\Foundation\Http\FormRequest;

class StoreProjectRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'title' => 'required|string|max:200',
            'description' => 'nullable|string',
            'thumbnail' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'category_id' => 'required|exists:portfolio_categories,id',
            'images' => 'nullable|array',
            'images.*' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'captions' => 'nullable|array',
            'captions.*' => 'nullable|string',
            'order' => 'nullable|integer',
            'is_active' => 'nullable|boolean',
            'features.*' => 'required|string|max:255',
        ];
    }

    public function messages(): array
    {
        return [
            'title.required' => 'The project title is required',
            'title.max' => 'The project title cannot exceed 200 characters',
            'thumbnail.required' => 'A thumbnail image is required',
            'thumbnail.image' => 'The thumbnail must be an image file',
            'category_id.required' => 'Please select a category',
            'category_id.exists' => 'The selected category does not exist',
            'images.*.image' => 'All uploaded files must be images',
            'images.*.max' => 'Image size cannot exceed 2MB'
        ];
    }
} 