<?php

namespace App\Services;

use App\Models\ArticleCategory;
use Illuminate\Database\Eloquent\Collection;

class ArticleCategoryService extends CategoryService
{
    /**
     * Get all categories with article counts
     */
    public function getAllWithArticleCounts(): Collection
    {
        return $this->getAllWithCount(ArticleCategory::class, 'articles');
    }

    /**
     * Create a new article category
     */
    public function create(array $data): ArticleCategory
    {
        return $this->createCategory(ArticleCategory::class, $data);
    }

    /**
     * Update an existing article category
     */
    public function update(ArticleCategory $category, array $data): ArticleCategory
    {
        return $this->updateCategory($category, $data);
    }

    /**
     * Delete an article category
     */
    public function delete(ArticleCategory $category): void
    {
        $this->deleteCategory($category);
    }
}