<?php

namespace App\Services;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Collection;

abstract class CategoryService extends BaseService
{
    /**
     * Get all categories with counts
     */
    protected function getAllWithCount(string $modelClass, string $relationshipCount): Collection
    {
        return $modelClass::withCount($relationshipCount)->get();
    }

    /**
     * Create a new category
     */
    protected function createCategory(string $modelClass, array $data): Model
    {
        return $modelClass::create($data);
    }

    /**
     * Update an existing category
     */
    protected function updateCategory(Model $category, array $data): Model
    {
        $category->update($data);
        return $category;
    }

    /**
     * Delete a category
     */
    protected function deleteCategory(Model $category): void
    {
        $category->delete();
    }
}