<?php

namespace App\Services;

use App\Models\Contact;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Collection;

class ContactService extends BaseService
{
    /**
     * Get paginated contacts
     */
    public function getPaginated(): LengthAwarePaginator
    {
        return Contact::latest()->paginate(20);
    }

    /**
     * Get unread contacts
     */
    public function getUnread(): Collection
    {
        return Contact::unread()->latest()->get();
    }

    /**
     * Create a new contact
     */
    public function create(array $data): Contact
    {
        return Contact::create($data);
    }

    /**
     * Mark contact as read
     */
    public function markAsRead(Contact $contact): Contact
    {
        if (!$contact->is_read) {
            $contact->markAsRead();
        }
        return $contact;
    }

    /**
     * Delete a contact
     */
    public function delete(Contact $contact): void
    {
        $contact->delete();
    }
}