<?php

namespace App\Services;

use App\Models\OurClient;
use Illuminate\Support\Facades\Log;
class OurClientService extends BaseService
{
    public function getAllActiveClients()
    {
        return OurClient::active()->ordered()->get();
    }

    public function getClientById($id)
    {
        return OurClient::findOrFail($id);
    }

    public function createClient(array $data)
    {
        $data['logo_path'] = $this->uploadFile($data['logo_path'], 'clients');
        $data['name'] = $data['name'] ?? "Client Name";
        $data['website_url'] = $data['website_url'] ?? null;
        $data['display_order'] = $data['display_order'] ?? 0;
        $data['is_active'] = true;
        return OurClient::create($data);
    }

    public function updateClient(OurClient $client, array $data)
    {
        Log::info($data);
        if (isset($data['logo_path'])) {
            $data['logo_path'] = $this->uploadFile($data['logo_path'], 'clients');
        }
        $data['name'] = $data['name'] ?? "Client Name";
        $data['website_url'] = $data['website_url'] ?? null;
        $data['display_order'] = $data['display_order'] ?? 0;
        $data['is_active'] = true;
        $client->update($data);
        return $client;
    }

    public function deleteClient(OurClient $client) 
    {
        $this->deleteFile($client->logo_path);
        $client->delete();
    }
    
}