<?php

namespace App\Services;

use App\Models\Testimonial;
use Illuminate\Database\Eloquent\Collection;

class TestimonialService extends BaseService
{

    public function getAllActive(): Collection
    {
        // return Testimonial::active()->ordered()->get();
        return Testimonial::ordered()->get();
    }

    public function create(array $data): Testimonial
    {
        if (isset($data['avatar'])) {
            $data['avatar'] = $this->uploadFile($data['avatar'], 'testimonials');
        }

        return Testimonial::create($data);
    }

    public function update(Testimonial $testimonial, array $data): Testimonial
    {
        if (isset($data['avatar'])) {
            $this->deleteFile($testimonial->avatar);
            $data['avatar'] = $this->uploadFile($data['avatar'], 'testimonials');
        } else {
            $data['avatar'] = $testimonial->avatar;
        }

        $testimonial->update($data);
        return $testimonial;
    }

    public function delete(Testimonial $testimonial): void
    {
        $this->deleteFile($testimonial->avatar);
        $testimonial->delete();
    }
}