<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\ServiceController;
use App\Http\Controllers\API\PortfolioCategoryController;
use App\Http\Controllers\API\PortfolioController;
use App\Http\Controllers\API\TestimonialController;
use App\Http\Controllers\API\ArticleCategoryController;
use App\Http\Controllers\API\ArticleController;
use App\Http\Controllers\API\ContactController;
use App\Http\Controllers\API\CompanyController;
use App\Http\Controllers\API\DashboardController;
use App\Http\Controllers\API\PortfolioSettingController;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\API\HeroImageController;
use App\Http\Controllers\API\OurClientController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Public API Routes
Route::prefix('v1')->group(function () {
    // Auth Routes
    Route::post('/auth/register', [AuthController::class, 'register']);
    Route::post('/auth/login', [AuthController::class, 'login']);
    
    // Protected Auth Routes
    Route::middleware('auth:sanctum')->group(function () {
        Route::get('/auth/profile', [AuthController::class, 'profile']);
        Route::get('/auth/me', [AuthController::class, 'profile']);
        Route::post('/auth/logout', [AuthController::class, 'logout']);
    });

    //Dashboard item
    Route::group(['prefix' => 'dashboard'], function () {
        Route::get('/', [DashboardController::class, 'dashboard']);
    });

    // Hero Image
    Route::group(['prefix' => 'hero-images'], function () {
        Route::get('/', [HeroImageController::class, 'index']);
        Route::post('/', [HeroImageController::class, 'store']);
        Route::get('/{heroImage}', [HeroImageController::class, 'show']);
        Route::put('/{heroImage}', [HeroImageController::class, 'update']);
        Route::delete('/{heroImage}', [HeroImageController::class, 'destroy']);
    });

    // Services
    Route::group(['prefix' => 'services'], function () {
        Route::get('/', [ServiceController::class, 'index']);
        Route::post('/', [ServiceController::class, 'store']);
        Route::get('/{service}', [ServiceController::class, 'show']);
        Route::put('/{service}', [ServiceController::class, 'update']);
        Route::delete('/{service}', [ServiceController::class, 'destroy']);
    });
    
    // Portfolio
    Route::group(['prefix' => 'portfolio-categories'], function () {
        Route::get('/', [PortfolioCategoryController::class, 'index']);
        Route::post('/', [PortfolioCategoryController::class, 'store']);
        Route::get('/{portfolioCategory}', [PortfolioCategoryController::class, 'show']);
        Route::put('/{portfolioCategory}', [PortfolioCategoryController::class, 'update']);
        Route::delete('/{portfolioCategory}', [PortfolioCategoryController::class, 'destroy']);
    });

    Route::group(['prefix' => 'portfolio-projects'], function () {
        Route::get('/', [PortfolioController::class, 'index']);
        Route::post('/', [PortfolioController::class, 'store']);
        // Route::get('/{portfolioProject}', [PortfolioController::class, 'show']);
        Route::get('/{slug}', [PortfolioController::class, 'showBySlug']);
        Route::put('/{portfolioProject}', [PortfolioController::class, 'update']);
        Route::delete('/{portfolioProject}', [PortfolioController::class, 'destroy']);
    });
    
    // Testimonials
    Route::group(['prefix' => 'testimonials'], function () {
        Route::get('/', [TestimonialController::class, 'index']);
        Route::post('/', [TestimonialController::class, 'store']);
        Route::get('/{testimonial}', [TestimonialController::class, 'show']);
        Route::put('/{testimonial}', [TestimonialController::class, 'update']);
        Route::delete('/{testimonial}', [TestimonialController::class, 'destroy']);
    });
    
    // Articles
    Route::get('articles/by-slug/{slug}', [ArticleController::class, 'bySlug']);
    
    Route::group(['prefix' => 'article-categories'], function () {
        Route::get('/', [ArticleCategoryController::class, 'index']);
        Route::post('/', [ArticleCategoryController::class, 'store']);
        Route::get('/{articleCategory}', [ArticleCategoryController::class, 'show']);
        Route::put('/{articleCategory}', [ArticleCategoryController::class, 'update']);
        Route::delete('/{articleCategory}', [ArticleCategoryController::class, 'destroy']);
    });

    Route::group(['prefix' => 'articles'], function () {
        Route::get('/', [ArticleController::class, 'index']);
        Route::post('/', [ArticleController::class, 'store']);
        Route::get('/{article}', [ArticleController::class, 'show']);
        Route::put('/{article}', [ArticleController::class, 'update']);
        Route::delete('/{article}', [ArticleController::class, 'destroy']);
    });
    
    // Contacts
    Route::get('contacts/unread', [ContactController::class, 'unread']);
    Route::group(['prefix' => 'contacts'], function () {
        Route::get('/', [ContactController::class, 'index']);
        Route::post('/', [ContactController::class, 'store']);
        Route::get('/{contact}', [ContactController::class, 'show']);
        Route::put('/{contact}', [ContactController::class, 'update']);
        Route::delete('/{contact}', [ContactController::class, 'destroy']);
    });

    // Company
    Route::group(['prefix' => 'about-company'], function () {
        Route::get('/', [CompanyController::class, 'show']);
        Route::put('/', [CompanyController::class, 'update']);
    });

    Route::group(['prefix' => 'portfolio-settings'], function () {
        Route::get('/', [PortfolioSettingController::class, 'index']);
        Route::get('/{key}', [PortfolioSettingController::class, 'show']);
        // Route::post('/{key}', [PortfolioSettingController::class, 'update']);
        Route::post('/bulk', [PortfolioSettingController::class, 'bulkUpdate']);
        Route::delete('/{key}', [PortfolioSettingController::class, 'destroy']);
        // upload image
        Route::post('/upload-image', [PortfolioSettingController::class, 'uploadSettingImage']);
    });

    // Our Clients
    Route::group(['prefix' => 'our-clients'], function () {
        Route::get('/', [OurClientController::class, 'index']);
        Route::post('/', [OurClientController::class, 'store']);
        Route::get('/{ourClient}', [OurClientController::class, 'show']);
        Route::put('/{ourClient}', [OurClientController::class, 'update']);
        Route::delete('/{ourClient}', [OurClientController::class, 'destroy']);
    });
});
